/*
 * Decompiled with CFR 0.152.
 */
package nmrsvd;

import Jampack.H;
import Jampack.JampackException;
import Jampack.Parameters;
import Jampack.Times;
import Jampack.Z;
import Jampack.Zmat;
import Jampack.Zsvd;
import java.util.Observable;

public class SVDMVCModel
extends Observable {
    private double[] fidRe;
    private double[] fidIm;
    private int maxNbComplex;
    private int n;
    private int m;
    private double[] eigenvalue;
    private double[] absorption;
    private double[] dispersion;
    private double anglePhi0;
    private double anglePhi1;
    private Zmat UU;
    private Zmat VV;

    public SVDMVCModel() {
        this.absorption = new double[this.maxNbComplex];
        this.dispersion = new double[this.maxNbComplex];
    }

    public int getmaxNbComplex() {
        return this.maxNbComplex;
    }

    public void setmaxNbComplex(int x) {
        int size = x / 2;
        if (x % 2 == 0) {
            this.n = size + 1;
            this.m = size;
        } else {
            this.n = size + 1;
            this.m = size + 1;
        }
        this.maxNbComplex = x;
    }

    public int getmvalue() {
        return this.m;
    }

    public int setmvalue(int x) {
        this.m = x;
        return this.m;
    }

    public int getnvalue() {
        return this.n;
    }

    public int setnvalue(int x) {
        this.n = x;
        return this.n;
    }

    public double[] getfidRe() {
        return this.fidRe;
    }

    public double[] setfidRe(double[] x) {
        this.fidRe = x;
        return x;
    }

    public double[] getfidIm() {
        return this.fidIm;
    }

    public double[] setfidIm(double[] x) {
        this.fidIm = x;
        return x;
    }

    public double[] getSVD() {
        return this.eigenvalue;
    }

    public double[] setSVD(double[] x) {
        this.eigenvalue = x;
        return x;
    }

    public double[] getAbsorption() {
        return this.absorption;
    }

    public double[] setAbsorption(double[] x) {
        this.absorption = x;
        return x;
    }

    public double[] getDispersion() {
        return this.dispersion;
    }

    public double[] setDispersion(double[] x) {
        this.dispersion = x;
        return x;
    }

    public double getPhi0() {
        return this.anglePhi0;
    }

    public double setPhi0(double x) {
        this.anglePhi0 = x;
        return this.anglePhi0;
    }

    public double getPhi1() {
        return this.anglePhi1;
    }

    public double setPhi1(double x) {
        this.anglePhi1 = x;
        return this.anglePhi1;
    }

    public void essaisetBaseIndex() throws JampackException {
        Parameters.setBaseIndex(0);
        Zsvd.MAXITER = 100;
    }

    public void essaiZsvd() throws JampackException {
        int i;
        int p = 0;
        Z[][] ary = new Z[this.n][this.m];
        for (i = 0; i < this.m; ++i) {
            ary[0][i] = new Z(this.fidRe[p], this.fidIm[p]);
            ++p;
        }
        for (i = 1; i < this.n; ++i) {
            ary[i][this.m - 1] = new Z(this.fidRe[p], this.fidIm[p]);
            ++p;
        }
        for (i = 1; i < this.n; ++i) {
            for (int j = 0; j < this.m - 1; ++j) {
                ary[i][j] = ary[i - 1][j + 1];
            }
        }
        Zmat X = new Zmat(ary);
        Zsvd SVD = new Zsvd(X);
        this.UU = SVD.U;
        this.VV = SVD.V;
        double[] eigenvaluereal = new double[this.m];
        for (int i2 = 0; i2 < this.m; ++i2) {
            eigenvaluereal[i2] = SVD.S.get((int)i2).re;
        }
        this.eigenvalue = eigenvaluereal;
    }

    public void createFID() throws JampackException {
        int j;
        int i;
        Zmat ev = new Zmat(this.n, this.m);
        Z tmp = new Z(0.0, 0.0);
        for (int i2 = 0; i2 < this.m; ++i2) {
            tmp.re = this.eigenvalue[i2];
            ev.put(i2, i2, tmp);
        }
        Zmat hankel = Times.o(Times.o(this.UU, ev), H.o(this.VV));
        for (i = 0; i < this.maxNbComplex; ++i) {
            this.fidRe[i] = 0.0;
            this.fidIm[i] = 0.0;
        }
        for (i = 0; i < this.m; ++i) {
            for (j = 0; j <= i; ++j) {
                int n = i;
                this.fidRe[n] = this.fidRe[n] + hankel.get((int)(i - j), (int)j).re;
                int n2 = i;
                this.fidIm[n2] = this.fidIm[n2] + hankel.get((int)(i - j), (int)j).im;
            }
            int n = i;
            this.fidRe[n] = this.fidRe[n] / (double)(i + 1);
            int n3 = i;
            this.fidIm[n3] = this.fidIm[n3] / (double)(i + 1);
        }
        for (i = 1; i < this.n; ++i) {
            for (j = 0; j < this.n - i; ++j) {
                int n = this.m - 1 + i;
                this.fidRe[n] = this.fidRe[n] + hankel.get((int)(i + j), (int)(this.m - 1 - j)).re;
                int n4 = this.m - 1 + i;
                this.fidIm[n4] = this.fidIm[n4] + hankel.get((int)(i + j), (int)(this.m - 1 - j)).im;
            }
            int n = this.m - 1 + i;
            this.fidRe[n] = this.fidRe[n] / (double)(this.n - i);
            int n5 = this.m - 1 + i;
            this.fidIm[n5] = this.fidIm[n5] / (double)(this.n - i);
        }
    }
}

