/*
 * Decompiled with CFR 0.152.
 */
package nmrsvd;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JPanel;
import nmrsvd.ListGentle;

public class Graph
extends JPanel {
    private String xAxisTitle;
    private String yAxisTitle;
    private String graphTitle;
    private boolean keys;
    private ListGentle points;
    private ListGentle datasets;
    private double xSpread;
    private double ySpread;
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    private int xAxisLength;
    private int yAxisLength;
    private int xOrigin;
    private int yOrigin;
    private int xBorder;
    private int yBorder;
    private static final int cs = 3;
    public final int red = 3;
    public final int blue = 2;
    public final int magenta = 1;
    public final int black = 0;

    public void Graph() {
        this.initializeGraph();
        this.graphTitle = "";
        this.xAxisTitle = "";
        this.yAxisTitle = "";
    }

    public void Graph(String g, String x, String y) {
        this.initializeGraph();
        this.graphTitle = g;
        this.xAxisTitle = x;
        this.yAxisTitle = y;
    }

    private void initializeGraph() {
        this.datasets = new ListGentle();
        this.nextGraph();
        this.points = new ListGentle();
        this.yMax = Double.MIN_VALUE;
        this.xMax = Double.MIN_VALUE;
        this.yMin = Double.MAX_VALUE;
        this.xMin = Double.MAX_VALUE;
        this.keys = false;
    }

    public void nextGraph() {
        Dataset d = new Dataset();
        d.count = 0;
        d.plotType = 0;
        d.title = "";
        d.symbolRequired = false;
        d.colorRequired = false;
        d.titleRequired = false;
        d.lineRequired = true;
        this.datasets.add(d);
    }

    public void setColor(int c) {
        ((Dataset)this.datasets.current()).colorRequired = true;
        ((Dataset)this.datasets.current()).plotType = c;
    }

    public void setSymbol(boolean b) {
        ((Dataset)this.datasets.current()).symbolRequired = b;
    }

    public void setSymbol(int c) {
        ((Dataset)this.datasets.current()).symbolRequired = true;
        ((Dataset)this.datasets.current()).plotType = c;
    }

    public void setTitle(String s) {
        ((Dataset)this.datasets.current()).titleRequired = true;
        ((Dataset)this.datasets.current()).title = s;
        this.keys = true;
    }

    public void setLine(boolean b) {
        ((Dataset)this.datasets.current()).lineRequired = b;
        if (!b) {
            ((Dataset)this.datasets.current()).symbolRequired = true;
        }
    }

    public void add(double x, double y) {
        this.points.add(new Point(x, y));
        ++((Dataset)this.datasets.current()).count;
        if (x > this.xMax) {
            this.xMax = x;
        }
        if (x < this.xMin) {
            this.xMin = x;
        }
        if (y > this.yMax) {
            this.yMax = y;
        }
        if (y < this.yMin) {
            this.yMin = y;
        }
    }

    public void showGraph() {
        this.repaint();
        this.setVisible(true);
    }

    private void drawTitles(Graphics g) {
        int x = this.xBorder;
        int y = this.getHeight() - this.yBorder / 2;
        this.datasets.reset();
        boolean lastset = this.datasets.eol();
        while (!lastset) {
            Dataset d = (Dataset)this.datasets.current();
            if (d.colorRequired) {
                this.changeColor(g, d.plotType);
            }
            if (d.symbolRequired) {
                this.drawSymbol(g, d.plotType, x, y - 3);
                x += 12;
            }
            g.drawString(d.title, x, y);
            x += g.getFontMetrics().stringWidth(d.title) + 20;
            lastset = this.datasets.eol();
            if (lastset) continue;
            this.datasets.succ();
        }
        g.setColor(Color.black);
    }

    private void drawAxes(Graphics g) {
        Font plain = g.getFont();
        Font small = new Font(plain.getFamily(), 0, 10);
        Font bold = new Font(plain.getFamily(), 1, 14);
        g.drawLine(this.xBorder - 5, this.yOrigin, this.xAxisLength + this.xBorder + 5, this.yOrigin);
        g.drawLine(this.xOrigin, this.yBorder - 5, this.xOrigin, this.yAxisLength + this.yBorder + 5);
        g.drawString(this.xAxisTitle, this.getWidth() - g.getFontMetrics().stringWidth(this.xAxisTitle) - this.xBorder / 2, this.yOrigin - 5);
        g.drawString(this.yAxisTitle, this.xOrigin - g.getFontMetrics().stringWidth(this.yAxisTitle) / 2, this.yBorder - 8);
        g.setFont(bold);
        g.drawString(this.graphTitle, (this.getWidth() - g.getFontMetrics().stringWidth(this.graphTitle)) / 2, this.yBorder / 2);
        g.setFont(plain);
        if (this.keys) {
            this.drawTitles(g);
        }
        int scaleXMin = this.scaleX(this.xMin);
        int scaleXMax = this.scaleX(this.xMax);
        int scaleYMin = this.scaleY(this.yMin);
        int scaleYMax = this.scaleY(this.yMax);
        g.drawLine(this.xOrigin - 5, scaleYMax, this.xOrigin + 5, scaleYMax);
        g.drawLine(this.xOrigin - 5, scaleYMin, this.xOrigin + 5, scaleYMin);
        g.drawLine(scaleXMax, this.yOrigin + 5, scaleXMax, this.yOrigin);
        g.drawLine(scaleXMin, this.yOrigin + 5, scaleXMin, this.yOrigin);
        g.setFont(small);
        g.drawString(Double.toString(this.xMin), scaleXMin - 10, this.yOrigin + 15);
        g.drawString(Double.toString(this.xMax), scaleXMax - 10, this.yOrigin + 15);
        g.drawString(Double.toString((double)Math.round(100.0 * this.yMin) / 100.0), this.xOrigin - 35, scaleYMin + 4);
        g.drawString(Double.toString((double)Math.round(100.0 * this.yMax) / 100.0), this.xOrigin - 35, scaleYMax + 4);
        g.setFont(plain);
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.xBorder = 40;
        this.yBorder = 80;
        this.xAxisLength = this.getWidth() - 2 * this.xBorder;
        this.yAxisLength = this.getHeight() - 2 * this.yBorder;
        this.xSpread = this.xMax - this.xMin;
        this.ySpread = this.yMax - this.yMin;
        this.xOrigin = this.xMin > 0.0 ? this.scaleX(this.xMin) : this.scaleX(0.0);
        this.yOrigin = this.yMin > 0.0 ? this.scaleY(this.yMin) : this.scaleY(0.0);
        this.drawAxes(g);
        this.plotGraphs(g);
    }

    private int scaleX(double x) {
        return (int)((x - this.xMin) / this.xSpread * (double)this.xAxisLength) + this.xBorder;
    }

    private int scaleY(double y) {
        return (int)((double)this.yAxisLength - (y - this.yMin) / this.ySpread * (double)this.yAxisLength) + this.yBorder;
    }

    private void changeColor(Graphics g, int c) {
        switch (c) {
            case 0: {
                g.setColor(Color.black);
                break;
            }
            case 1: {
                g.setColor(Color.magenta);
                break;
            }
            case 2: {
                g.setColor(Color.blue);
                break;
            }
            case 3: {
                g.setColor(Color.red);
            }
        }
    }

    private void drawSymbol(Graphics g, int sy, int x, int y) {
        switch (sy) {
            case 0: {
                g.drawOval(x - 3, y - 3, 6, 6);
                break;
            }
            case 1: {
                g.drawPolygon(this.trix(x), this.uptriy(y), 3);
                break;
            }
            case 2: {
                g.drawPolygon(this.trix(x), this.triy(y), 3);
                break;
            }
            case 3: {
                g.drawRect(x - 3, y - 3, 6, 6);
            }
        }
    }

    private void plotGraphs(Graphics g) {
        this.datasets.reset();
        this.points.reset();
        boolean lastset = this.datasets.eol();
        do {
            Dataset d = (Dataset)this.datasets.current();
            if (d.colorRequired) {
                this.changeColor(g, d.plotType);
            }
            Point p = (Point)this.points.current();
            int x1 = this.scaleX(p.xCoord);
            int y1 = this.scaleY(p.yCoord);
            if (d.symbolRequired) {
                this.drawSymbol(g, d.plotType, x1, y1);
            }
            for (int i = 1; i < d.count; ++i) {
                this.points.succ();
                Point q = (Point)this.points.current();
                int x2 = this.scaleX(q.xCoord);
                int y2 = this.scaleY(q.yCoord);
                if (d.lineRequired) {
                    g.drawLine(x1, y1, x2, y2);
                }
                if (d.symbolRequired) {
                    this.drawSymbol(g, d.plotType, x2, y2);
                }
                x1 = x2;
                y1 = y2;
            }
            lastset = this.datasets.eol();
            if (lastset) continue;
            this.datasets.succ();
            this.points.succ();
        } while (!lastset);
    }

    private int[] trix(int p) {
        int[] a = new int[]{p - 3, p + 3, p};
        return a;
    }

    private int[] triy(int p) {
        int[] a = new int[]{p + 3, p + 3, p - 3};
        return a;
    }

    private int[] uptriy(int p) {
        int[] a = new int[]{p - 3, p - 3, p + 3};
        return a;
    }

    private class Point {
        double xCoord;
        double yCoord;

        Point(double x, double y) {
            this.xCoord = x;
            this.yCoord = y;
        }
    }

    private class Dataset {
        int count;
        int plotType;
        String title;
        boolean colorRequired;
        boolean symbolRequired;
        boolean titleRequired;
        boolean lineRequired;

        private Dataset() {
        }
    }
}

