/*
 * Decompiled with CFR 0.152.
 */
package nmrsvd;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import nmrsvd.Graph;
import nmrsvd.SVDMVCModel;

public class Frame1
extends JFrame {
    private SVDController controller = new SVDController();
    private Graph ggSVD = new Graph();
    private int labelHeight = 20;
    private int buttonHeight = 30;
    private int panelHeight = 400;
    private int panelWidth = 402;
    JMenuBar menuBar = new JMenuBar();
    JMenu menuFile = new JMenu("File");
    JMenuItem menuItemOpen = new JMenuItem("Open file...");
    JMenuItem menuItemSave = new JMenuItem("Save as...");
    JFileChooser fc = new JFileChooser();
    JPanel panelMatrix = new JPanel();
    JPanel panelFid = new JPanel();
    JPanel panelHeader = new JPanel();
    JPanel panelFidData = new JPanel();
    JLabel labelFidRe = new JLabel("Real");
    JLabel labelFidIm = new JLabel("Imaginary");
    JLabel labelFid1 = new JLabel("FID");
    JLabel labelFid2 = new JLabel("FID");
    JTextArea textAreaFIDReal = new JTextArea();
    JTextArea textAreaFIDImag = new JTextArea();
    JScrollPane scrollPaneFid = new JScrollPane();
    JButton buttonClearFID = new JButton("Clear FID");
    JButton buttonRunSVD = new JButton("Run SVD");
    JPanel panelSVD = new JPanel();
    JPanel panelEigenValue = new JPanel();
    JPanel panelEigenValueHeader = new JPanel();
    JPanel panelEigenValueData = new JPanel();
    JLabel labelEigen = new JLabel("Eigen values");
    JTextField textFieldSVD = new JTextField("2");
    JTextArea textAreaEigenValue = new JTextArea();
    JScrollPane scrollPaneEigenValue = new JScrollPane();
    JButton buttonHankel = new JButton("Hankel");

    public Frame1() {
        try {
            this.setDefaultCloseOperation(3);
            this.setSize(new Dimension(400, 460));
            this.setTitle("www.pascal-man.com: SVD denoising FID");
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        SVDMVCModel modela = new SVDMVCModel();
        try {
            modela.essaisetBaseIndex();
        }
        catch (Exception e) {
            this.buttonRunSVD.setBackground(Color.yellow);
        }
        this.panelMatrix.setVisible(true);
        this.panelSVD.setVisible(false);
        this.menuFile.setEnabled(true);
        this.fc.setFileSelectionMode(2);
        this.setJMenuBar(this.menuBar);
        this.menuBar.add(this.menuFile);
        this.menuFile.add(this.menuItemOpen);
        this.menuFile.add(this.menuItemSave);
        this.setBackground(Color.white);
        this.getContentPane().setLayout(null);
        this.panelMatrix.setLayout(null);
        this.panelMatrix.setBackground(Color.yellow);
        this.panelMatrix.setBounds(2, 2, this.panelWidth, this.panelHeight);
        this.panelMatrix.setFont(new Font("TimesRoman", 0, 12));
        this.getContentPane().add(this.panelMatrix);
        this.panelFid.setBounds(2, 2, 200, this.panelHeight - 4);
        this.panelMatrix.add(this.panelFid);
        this.panelFid.setBackground(Color.pink);
        this.panelFid.setLayout(null);
        this.panelFid.setFont(new Font("TimesRoman", 0, 12));
        this.panelHeader.setBounds(10, 7, 180, 2 * this.labelHeight);
        this.panelHeader.setLayout(null);
        this.panelHeader.setBackground(Color.pink);
        this.labelFidRe.setBounds(0, 0, 90, this.labelHeight);
        this.panelHeader.add(this.labelFidRe);
        this.labelFidIm.setBounds(90, 0, 90, this.labelHeight);
        this.panelHeader.add(this.labelFidIm);
        this.labelFid1.setBounds(0, this.labelHeight, 90, this.labelHeight);
        this.panelHeader.add(this.labelFid1);
        this.labelFid2.setBounds(90, this.labelHeight, 90, this.labelHeight);
        this.panelHeader.add(this.labelFid2);
        this.panelFid.add(this.panelHeader);
        this.scrollPaneFid.setBounds(10, 50, 180, 240);
        this.scrollPaneFid.getViewport().add(this.panelFidData);
        this.panelFid.add(this.scrollPaneFid);
        this.panelFidData.setLayout(new GridLayout(1, 2));
        this.panelFidData.add(this.textAreaFIDReal);
        this.panelFidData.add(this.textAreaFIDImag);
        this.textAreaFIDReal.setBackground(Color.orange);
        this.textAreaFIDImag.setBackground(Color.yellow);
        this.textAreaFIDReal.setMargin(new Insets(5, 5, 5, 5));
        this.textAreaFIDImag.setMargin(new Insets(5, 5, 5, 5));
        this.textAreaFIDReal.setEditable(true);
        this.textAreaFIDImag.setEditable(true);
        this.buttonRunSVD.setBounds(40, 300, 115, this.buttonHeight);
        this.buttonRunSVD.setBackground(Color.red);
        this.panelFid.add(this.buttonRunSVD);
        this.buttonClearFID.setBounds(40, 350, 115, this.buttonHeight);
        this.buttonClearFID.setBackground(Color.red);
        this.panelFid.add(this.buttonClearFID);
        this.panelSVD.setLayout(null);
        this.panelSVD.setBackground(Color.yellow);
        this.panelSVD.setBounds(2, 2, this.panelWidth, this.panelHeight);
        this.panelSVD.setFont(new Font("TimesRoman", 0, 12));
        this.getContentPane().add(this.panelSVD);
        this.panelEigenValue.setBounds(2, 2, this.panelWidth - 4, this.panelHeight - 4);
        this.panelSVD.add(this.panelEigenValue);
        this.panelEigenValue.setBackground(Color.pink);
        this.panelEigenValue.setLayout(null);
        this.panelEigenValue.setFont(new Font("TimesRoman", 0, 12));
        this.panelEigenValueHeader.setBounds(10, 7, 120, this.labelHeight);
        this.panelEigenValueHeader.setLayout(null);
        this.panelEigenValueHeader.setBackground(Color.pink);
        this.labelEigen.setBounds(0, 0, 120, this.labelHeight);
        this.panelEigenValueHeader.add(this.labelEigen);
        this.panelEigenValue.add(this.panelEigenValueHeader);
        this.scrollPaneEigenValue.setBounds(10, this.labelHeight + 10, 260, 80);
        this.scrollPaneEigenValue.getViewport().add(this.panelEigenValueData);
        this.panelEigenValue.add(this.scrollPaneEigenValue);
        this.panelEigenValueData.setLayout(new GridLayout(1, 1));
        this.panelEigenValueData.add(this.textAreaEigenValue);
        this.textAreaEigenValue.setBackground(Color.orange);
        this.textAreaEigenValue.setMargin(new Insets(5, 5, 5, 5));
        this.textAreaEigenValue.setEditable(true);
        this.textFieldSVD.setBounds(290, this.labelHeight + 10, 95, this.buttonHeight);
        this.textFieldSVD.setBackground(Color.white);
        this.panelEigenValue.add(this.textFieldSVD);
        this.buttonHankel.setBounds(290, 100 - this.labelHeight, 95, this.buttonHeight);
        this.buttonHankel.setBackground(Color.red);
        this.panelEigenValue.add(this.buttonHankel);
        this.ggSVD.setBounds(10, 110, this.panelWidth - 25, 275);
        this.ggSVD.setBackground(Color.pink);
        this.panelEigenValue.add(this.ggSVD);
        this.ggSVD.setVisible(false);
        this.buttonRunSVD.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Frame1.this.buttonRunSVD.getText() == "Run SVD") {
                    Frame1.this.controller.buttonRunSVD();
                }
            }
        });
        this.buttonClearFID.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Frame1.this.buttonClearFID.getText() == "Clear FID") {
                    Frame1.this.controller.buttonClearFID();
                }
            }
        });
        this.buttonHankel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Frame1.this.buttonHankel.getText() == "Hankel") {
                    Frame1.this.controller.buttonHankel();
                }
            }
        });
        this.menuItemOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Frame1.this.menuItemOpen.getText() == "Open file...") {
                    Frame1.this.controller.menuItemOpen();
                }
            }
        });
        this.menuItemSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Frame1.this.menuItemSave.getText() == "Save as...") {
                    Frame1.this.controller.menuItemSave();
                }
            }
        });
    }

    private class SVDController {
        public SVDMVCModel model = new SVDMVCModel();
        final double ANGLE_DEGRE = Math.PI / 180;
        File fn = new File("denoised.txt");

        private void menuItemOpen() {
            int returnVal = Frame1.this.fc.showOpenDialog(Frame1.this);
            if (returnVal == 0) {
                try {
                    File file = Frame1.this.fc.getSelectedFile();
                    if (file != null) {
                        BufferedReader br = new BufferedReader(new FileReader(file));
                        String ligne = null;
                        String ssr = "";
                        String ssi = "";
                        while ((ligne = br.readLine()) != null) {
                            String[] strings = ligne.split(" ");
                            ssr = ssr + strings[0] + "\n";
                            ssi = ssi + strings[1] + "\n";
                        }
                        br.close();
                        Frame1.this.textAreaFIDReal.setText(ssr);
                        Frame1.this.textAreaFIDImag.setText(ssi);
                    }
                }
                catch (IOException e) {
                    System.err.println(e);
                }
            }
        }

        private void menuItemSave() {
            Frame1.this.fc.setSelectedFile(this.fn);
            int returnVal = Frame1.this.fc.showSaveDialog(Frame1.this);
            if (returnVal == 0) {
                try {
                    File file = Frame1.this.fc.getSelectedFile();
                    if (file != null) {
                        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
                        int lineCount = Frame1.this.textAreaFIDReal.getLineCount() - 1;
                        double[] fr = this.model.getfidRe();
                        double[] fi = this.model.getfidIm();
                        String st = "";
                        for (int i = 0; i < lineCount; ++i) {
                            st = Math.round(fr[i]) + " " + Math.round(fi[i]) + "\n";
                            bw.write(st);
                        }
                        bw.close();
                    }
                }
                catch (IOException e) {
                    System.err.println(e);
                }
            }
        }

        private void buttonClearFID() {
            Frame1.this.textAreaFIDReal.setText("");
            Frame1.this.textAreaFIDImag.setText("");
        }

        private void buttonRunSVD() {
            this.provideFid();
            try {
                this.model.essaiZsvd();
            }
            catch (Exception e) {
                Frame1.this.buttonRunSVD.setBackground(Color.green);
            }
            double[] titi = this.model.getSVD();
            String s2 = "";
            for (int j = 0; j < this.model.getmvalue(); ++j) {
                s2 = s2 + titi[j] + "\n";
            }
            Frame1.this.textAreaEigenValue.setText(s2);
            double[] tmp = this.model.getSVD();
            Frame1.this.ggSVD.Graph("SVD", "n", "svd");
            Frame1.this.ggSVD.setSymbol(true);
            Frame1.this.ggSVD.setLine(true);
            Frame1.this.ggSVD.setColor(((Frame1)Frame1.this).ggSVD.black);
            for (int i = 0; i < this.model.getmvalue(); ++i) {
                double inc = i;
                Frame1.this.ggSVD.add(inc, tmp[i]);
            }
            Frame1.this.ggSVD.showGraph();
            Frame1.this.panelMatrix.setVisible(false);
            Frame1.this.panelSVD.setVisible(true);
        }

        private void provideFid() {
            int lineCount = Frame1.this.textAreaFIDReal.getLineCount() - 1;
            this.model.setmaxNbComplex(lineCount);
            String sr = Frame1.this.textAreaFIDReal.getText();
            String s1r = "";
            int spaceAtr = 0;
            int startingFormr = 0;
            int ipr = 0;
            double[] tmpr = new double[this.model.getmaxNbComplex()];
            while ((spaceAtr = sr.indexOf("\n", startingFormr)) != -1) {
                s1r = sr.substring(startingFormr, spaceAtr);
                tmpr[ipr] = Double.valueOf(s1r);
                startingFormr = spaceAtr + 1;
                ++ipr;
            }
            this.model.setfidRe(tmpr);
            String si = Frame1.this.textAreaFIDImag.getText();
            String s1i = "";
            int spaceAti = 0;
            int startingFormi = 0;
            int ipi = 0;
            double[] tmpi = new double[this.model.getmaxNbComplex()];
            while ((spaceAti = si.indexOf("\n", startingFormi)) != -1) {
                s1i = si.substring(startingFormi, spaceAti);
                tmpi[ipi] = Double.valueOf(s1i);
                startingFormi = spaceAti + 1;
                ++ipi;
            }
            this.model.setfidIm(tmpi);
        }

        private void buttonHankel() {
            int nbSVD = Integer.parseInt(Frame1.this.textFieldSVD.getText());
            int mvalue = this.model.getmvalue();
            double[] usedSVD = new double[mvalue];
            String s = Frame1.this.textAreaEigenValue.getText();
            String s1 = "";
            int spaceAt = 0;
            int startingForm = 0;
            for (int i = 0; i < nbSVD && (spaceAt = s.indexOf("\n", startingForm)) != -1; ++i) {
                s1 = s.substring(startingForm, spaceAt);
                usedSVD[i] = Double.valueOf(s1);
                startingForm = spaceAt + 1;
            }
            this.model.setSVD(usedSVD);
            double[] titi = this.model.getSVD();
            String s2 = "";
            for (int j = 0; j < this.model.getmvalue(); ++j) {
                s2 = s2 + titi[j] + "\n";
            }
            Frame1.this.textAreaEigenValue.setText(s2);
            try {
                this.model.createFID();
                String sfidre = "";
                String sfidim = "";
                double[] fr = this.model.getfidRe();
                double[] fi = this.model.getfidIm();
                int max = this.model.getmaxNbComplex();
                for (int i = 0; i < max; ++i) {
                    sfidre = sfidre + fr[i] + "\n";
                    sfidim = sfidim + fi[i] + "\n";
                }
                Frame1.this.textAreaFIDReal.setText(sfidre);
                Frame1.this.textAreaFIDImag.setText(sfidim);
                Frame1.this.panelSVD.setVisible(false);
                Frame1.this.panelMatrix.setVisible(true);
            }
            catch (Exception e) {
                Frame1.this.textAreaEigenValue.setBackground(Color.green);
            }
        }
    }
}

