/*
 * Decompiled with CFR 0.152.
 */
package Jampack;

import Jampack.JampackException;
import Jampack.Parameters;
import Jampack.Z;
import Jampack.Z1;
import Jampack.Zchol;
import Jampack.Zdiagmat;
import Jampack.Zhqrd;
import Jampack.Zludpp;

public class Zmat {
    protected int nrow;
    protected int ncol;
    protected int basex;
    protected double[][] re;
    protected double[][] im;
    protected boolean dirty;
    protected Zludpp LU;
    protected Zhqrd HQR;
    protected Zchol CHOL;
    public int bx;
    public int rx;
    public int nr;
    public int cx;
    public int nc;

    public Zmat(double[][] dArray, double[][] dArray2) throws JampackException {
        Parameters.BaseIndexNotChangeable = true;
        this.basex = Parameters.BaseIndex;
        this.nrow = dArray.length;
        this.ncol = dArray[0].length;
        if (this.nrow != dArray2.length || this.ncol != dArray2[0].length) {
            throw new JampackException("Inconsistent array dimensions");
        }
        this.getProperties();
        this.re = new double[this.nr][this.nc];
        this.im = new double[this.nr][this.nc];
        int n = 0;
        while (n < this.nr) {
            int n2 = 0;
            while (n2 < this.nc) {
                this.re[n][n2] = dArray[n][n2];
                this.im[n][n2] = dArray2[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public Zmat(Z[][] zArray) {
        Parameters.BaseIndexNotChangeable = true;
        this.basex = Parameters.BaseIndex;
        this.nrow = zArray.length;
        this.ncol = zArray[0].length;
        this.getProperties();
        this.re = new double[this.nr][this.nc];
        this.im = new double[this.nr][this.nc];
        int n = 0;
        while (n < this.nr) {
            int n2 = 0;
            while (n2 < this.nc) {
                this.re[n][n2] = zArray[n][n2].re;
                this.im[n][n2] = zArray[n][n2].im;
                ++n2;
            }
            ++n;
        }
    }

    public Zmat(double[][] dArray) {
        Parameters.BaseIndexNotChangeable = true;
        this.basex = Parameters.BaseIndex;
        this.nrow = dArray.length;
        this.ncol = dArray[0].length;
        this.getProperties();
        this.re = new double[this.nr][this.nc];
        this.im = new double[this.nr][this.nc];
        int n = 0;
        while (n < this.nr) {
            int n2 = 0;
            while (n2 < this.nc) {
                this.re[n][n2] = dArray[n][n2];
                this.im[n][n2] = 0.0;
                ++n2;
            }
            ++n;
        }
    }

    public Zmat(Zmat zmat) {
        Parameters.BaseIndexNotChangeable = true;
        this.basex = Parameters.BaseIndex;
        this.nrow = zmat.nrow;
        this.ncol = zmat.ncol;
        this.getProperties();
        this.re = new double[this.nr][this.nc];
        this.im = new double[this.nr][this.nc];
        int n = 0;
        while (n < this.nr) {
            int n2 = 0;
            while (n2 < this.nc) {
                this.re[n][n2] = zmat.re[n][n2];
                this.im[n][n2] = zmat.im[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public Zmat(Z1 z1) {
        Parameters.BaseIndexNotChangeable = true;
        this.basex = Parameters.BaseIndex;
        this.nrow = z1.n;
        this.ncol = 1;
        this.getProperties();
        this.re = new double[this.nr][this.nc];
        this.im = new double[this.nr][this.nc];
        int n = 0;
        while (n < this.nr) {
            this.re[n][0] = z1.re[n];
            this.im[n][0] = z1.im[n];
            ++n;
        }
    }

    public Zmat(Zdiagmat zdiagmat) {
        Parameters.BaseIndexNotChangeable = true;
        this.basex = Parameters.BaseIndex;
        this.nrow = zdiagmat.n;
        this.ncol = zdiagmat.n;
        this.getProperties();
        this.re = new double[this.nr][this.nc];
        this.im = new double[this.nr][this.nc];
        int n = 0;
        while (n < this.nr) {
            this.re[n][n] = zdiagmat.re[n];
            this.im[n][n] = zdiagmat.im[n];
            ++n;
        }
    }

    public Zmat(int n, int n2) {
        Parameters.BaseIndexNotChangeable = true;
        this.basex = Parameters.BaseIndex;
        this.nrow = n;
        this.ncol = n2;
        this.getProperties();
        this.re = new double[this.nr][this.nc];
        this.im = new double[this.nr][this.nc];
        int n3 = 0;
        while (n3 < this.nr) {
            int n4 = 0;
            while (n4 < this.nc) {
                this.re[n3][n4] = 0.0;
                this.im[n3][n4] = 0.0;
                ++n4;
            }
            ++n3;
        }
    }

    public void getProperties() {
        this.bx = this.basex;
        this.rx = this.bx + this.nrow - 1;
        this.cx = this.bx + this.ncol - 1;
        this.nr = this.nrow;
        this.nc = this.ncol;
    }

    public double[][] getRe() {
        double[][] dArray = new double[this.nrow][this.ncol];
        int n = 0;
        while (n < this.nrow) {
            int n2 = 0;
            while (n2 < this.ncol) {
                dArray[n][n2] = this.re[n][n2];
                ++n2;
            }
            ++n;
        }
        return dArray;
    }

    public double[][] getIm() {
        double[][] dArray = new double[this.nrow][this.ncol];
        int n = 0;
        while (n < this.nrow) {
            int n2 = 0;
            while (n2 < this.ncol) {
                dArray[n][n2] = this.im[n][n2];
                ++n2;
            }
            ++n;
        }
        return dArray;
    }

    public Z[][] getZ() {
        Z[][] zArray = new Z[this.nrow][this.ncol];
        int n = 0;
        while (n < this.nrow) {
            int n2 = 0;
            while (n2 < this.ncol) {
                zArray[n][n2] = new Z(this.re[n][n2], this.im[n][n2]);
                ++n2;
            }
            ++n;
        }
        return zArray;
    }

    public Z get(int n, int n2) {
        return new Z(this.re[n - this.basex][n2 - this.basex], this.im[n - this.basex][n2 - this.basex]);
    }

    public Z get0(int n, int n2) {
        return new Z(this.re[n][n2], this.im[n][n2]);
    }

    public void put(int n, int n2, Z z) {
        this.dirty = true;
        this.re[n - this.basex][n2 - this.basex] = z.re;
        this.im[n - this.basex][n2 - this.basex] = z.im;
    }

    public void put0(int n, int n2, Z z) {
        this.dirty = true;
        this.re[n][n2] = z.re;
        this.im[n][n2] = z.im;
    }

    public Zmat get(int n, int n2, int n3, int n4) {
        int n5 = n2 - n + 1;
        int n6 = n4 - n3 + 1;
        Zmat zmat = new Zmat(n5, n6);
        int n7 = 0;
        while (n7 < n5) {
            int n8 = 0;
            while (n8 < n6) {
                zmat.re[n7][n8] = this.re[n7 + n - this.basex][n8 + n3 - this.basex];
                zmat.im[n7][n8] = this.im[n7 + n - this.basex][n8 + n3 - this.basex];
                ++n8;
            }
            ++n7;
        }
        return zmat;
    }

    public void put(int n, int n2, int n3, int n4, Zmat zmat) {
        this.dirty = true;
        int n5 = n2 - n + 1;
        int n6 = n4 - n3 + 1;
        int n7 = 0;
        while (n7 < n5) {
            int n8 = 0;
            while (n8 < n6) {
                this.re[n7 + n - this.basex][n8 + n3 - this.basex] = zmat.re[n7][n8];
                this.im[n7 + n - this.basex][n8 + n3 - this.basex] = zmat.im[n7][n8];
                ++n8;
            }
            ++n7;
        }
    }

    public Zmat get(int[] nArray, int n, int n2) {
        int n3 = nArray.length;
        int n4 = n2 - n + 1;
        Zmat zmat = new Zmat(n3, n4);
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            while (n6 < n4) {
                zmat.re[n5][n6] = this.re[nArray[n5] - this.basex][n6 + n - this.basex];
                zmat.im[n5][n6] = this.im[nArray[n5] - this.basex][n6 + n - this.basex];
                ++n6;
            }
            ++n5;
        }
        return zmat;
    }

    public void put(int[] nArray, int n, int n2, Zmat zmat) {
        this.dirty = true;
        int n3 = nArray.length;
        int n4 = n2 - n + 1;
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            while (n6 < n4) {
                this.re[nArray[n5] - this.basex][n6 + n - this.basex] = zmat.re[n5][n6];
                this.im[nArray[n5] - this.basex][n6 + n - this.basex] = zmat.im[n5][n6];
                ++n6;
            }
            ++n5;
        }
    }

    public Zmat get(int n, int n2, int[] nArray) {
        int n3 = n2 - n + 1;
        int n4 = nArray.length;
        Zmat zmat = new Zmat(n3, n4);
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            while (n6 < n4) {
                zmat.re[n5][n6] = this.re[n5 + n - this.basex][nArray[n6] - this.basex];
                zmat.im[n5][n6] = this.im[n5 + n - this.basex][nArray[n6] - this.basex];
                ++n6;
            }
            ++n5;
        }
        return zmat;
    }

    public void put(int n, int n2, int[] nArray, Zmat zmat) {
        this.dirty = true;
        int n3 = n2 - n + 1;
        int n4 = nArray.length;
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            while (n6 < n4) {
                this.re[n5 + n - this.basex][nArray[n6] - this.basex] = zmat.re[n5][n6];
                this.im[n5 + n - this.basex][nArray[n6] - this.basex] = zmat.im[n5][n6];
                ++n6;
            }
            ++n5;
        }
    }

    public Zmat get(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        int n2 = nArray2.length;
        Zmat zmat = new Zmat(n, n2);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                zmat.re[n3][n4] = this.re[nArray[n3] - this.basex][nArray2[n4] - this.basex];
                zmat.im[n3][n4] = this.im[nArray[n3] - this.basex][nArray2[n4] - this.basex];
                ++n4;
            }
            ++n3;
        }
        return zmat;
    }

    public void put(int[] nArray, int[] nArray2, Zmat zmat) {
        this.dirty = true;
        int n = nArray.length;
        int n2 = nArray2.length;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                this.re[nArray[n3] - this.basex][nArray2[n4] - this.basex] = zmat.re[n3][n4];
                this.im[nArray[n3] - this.basex][nArray2[n4] - this.basex] = zmat.im[n3][n4];
                ++n4;
            }
            ++n3;
        }
    }

    public Zludpp getLU() {
        this.clean();
        Zludpp zludpp = this.LU;
        this.LU = null;
        return zludpp;
    }

    public Zhqrd getHQR() {
        this.clean();
        Zhqrd zhqrd = this.HQR;
        this.HQR = null;
        return zhqrd;
    }

    public Zchol getCHOL() {
        this.clean();
        Zchol zchol = this.CHOL;
        this.CHOL = null;
        return zchol;
    }

    protected void clean() {
        if (this.dirty) {
            this.LU = null;
            this.HQR = null;
            this.CHOL = null;
            this.dirty = false;
        }
    }
}

