/*
 * Decompiled with CFR 0.152.
 */
package Jampack;

import Jampack.H;
import Jampack.House;
import Jampack.JampackException;
import Jampack.Z1;
import Jampack.Zmat;
import Jampack.Zutmat;

public class Zhqrd {
    public int nrow;
    public int ncol;
    public int ntran;
    public Z1[] U;
    public Zutmat R;

    public Zhqrd(Zmat zmat) throws JampackException {
        zmat.getProperties();
        this.nrow = zmat.nr;
        this.ncol = zmat.nc;
        this.ntran = Math.min(zmat.nr, zmat.nc);
        this.U = new Z1[this.ntran];
        this.R = new Zutmat(zmat);
        int n = zmat.bx;
        while (n < zmat.bx + this.ntran) {
            this.U[n - zmat.bx] = House.genc(this.R, n, zmat.rx, n);
            House.ua(this.U[n - zmat.bx], this.R, n, zmat.rx, n + 1, zmat.cx);
            ++n;
        }
        if (this.nrow > this.ncol) {
            this.R = new Zutmat(this.R.get(this.R.bx, this.R.cx, this.R.bx, this.R.cx));
        }
    }

    public Zmat qb(Zmat zmat) throws JampackException {
        if (zmat.ncol != this.ncol) {
            throw new JampackException("Inconsistent dimensions.");
        }
        Zmat zmat2 = new Zmat(zmat);
        int n = this.ntran - 1;
        while (n >= 0) {
            House.ua(this.U[n], zmat2, zmat2.bx + n, zmat2.rx, zmat2.bx, zmat2.cx);
            --n;
        }
        return zmat2;
    }

    public Zmat qhb(Zmat zmat) throws JampackException {
        if (zmat.ncol != this.ncol) {
            throw new JampackException("Inconsistent dimensions.");
        }
        Zmat zmat2 = new Zmat(zmat);
        int n = 0;
        while (n < this.ntran) {
            House.ua(this.U[n], zmat2, zmat2.bx + n, zmat2.rx, zmat2.bx, zmat2.cx);
            ++n;
        }
        return zmat2;
    }

    public Zmat bq(Zmat zmat) throws JampackException {
        if (zmat.nrow != this.ncol) {
            throw new JampackException("Inconsistent dimensions.");
        }
        return H.o(this.qhb(H.o(zmat)));
    }

    public Zmat bqh(Zmat zmat, Zmat zmat2) throws JampackException {
        if (zmat2.nrow != this.ncol) {
            throw new JampackException("Inconsistent dimensions.");
        }
        return H.o(this.qb(H.o(zmat2)));
    }
}

