/*
 * Decompiled with CFR 0.152.
 */
package Jampack;

import Jampack.JampackException;
import Jampack.Parameters;
import Jampack.Z;
import Jampack.Z1;
import Jampack.Zmat;

public class Zdiagmat {
    protected int order;
    protected int basex;
    protected double[] re;
    protected double[] im;
    public int n;
    public int bx;
    public int dx;

    public Zdiagmat(int n) {
        Parameters.BaseIndexNotChangeable = true;
        this.basex = Parameters.BaseIndex;
        this.order = n;
        this.getProperties();
        this.re = new double[this.n];
        this.im = new double[this.n];
    }

    public Zdiagmat(int n, Z z) {
        Parameters.BaseIndexNotChangeable = true;
        this.basex = Parameters.BaseIndex;
        this.order = n;
        this.getProperties();
        this.re = new double[this.n];
        this.im = new double[this.n];
        int n2 = 0;
        while (n2 < this.n) {
            this.re[n2] = z.re;
            this.im[n2] = z.im;
            ++n2;
        }
    }

    public Zdiagmat(Z1 z1) {
        Parameters.BaseIndexNotChangeable = true;
        this.bx = Parameters.BaseIndex;
        this.order = z1.re.length;
        this.getProperties();
        this.re = new double[this.n];
        this.im = new double[this.n];
        int n = 0;
        while (n < this.n) {
            this.re[n] = z1.re[n];
            this.im[n] = z1.im[n];
            ++n;
        }
    }

    public Zdiagmat(Zmat zmat, int n) throws JampackException {
        Parameters.BaseIndexNotChangeable = true;
        this.basex = Parameters.BaseIndex;
        if (n >= 0) {
            if (n >= zmat.ncol) {
                throw new JampackException("Diagonal out of range.");
            }
            this.order = Math.min(zmat.nrow, zmat.ncol - n);
            this.re = new double[this.order];
            this.im = new double[this.order];
            int n2 = 0;
            while (n2 < this.order) {
                this.re[n2] = zmat.re[n2][n2 + n];
                this.im[n2] = zmat.im[n2][n2 + n];
                ++n2;
            }
        } else {
            if ((n = -n) >= zmat.nrow) {
                throw new JampackException("Diagonal out of range.");
            }
            this.order = Math.min(zmat.nrow - n, zmat.ncol);
            this.re = new double[this.order];
            this.im = new double[this.order];
            int n3 = 0;
            while (n3 < this.order) {
                this.re[n3] = zmat.re[n3 + n][n3];
                this.im[n3] = zmat.im[n3 + n][n3];
                ++n3;
            }
        }
        this.getProperties();
    }

    public Zdiagmat(Zmat zmat) throws JampackException {
        this(zmat, 0);
    }

    public Zdiagmat(Zdiagmat zdiagmat) {
        Parameters.BaseIndexNotChangeable = true;
        this.basex = Parameters.BaseIndex;
        this.order = zdiagmat.order;
        this.getProperties();
        this.re = new double[this.n];
        this.im = new double[this.n];
        int n = 0;
        while (n < this.n) {
            this.re[n] = zdiagmat.re[n];
            this.im[n] = zdiagmat.im[n];
            ++n;
        }
    }

    public void getProperties() {
        this.bx = this.basex;
        this.dx = this.bx + this.order - 1;
        this.n = this.order;
    }

    public Z get(int n) {
        return new Z(this.re[n - this.bx], this.im[n - this.bx]);
    }

    public Z get0(int n) {
        return new Z(this.re[n], this.im[n]);
    }

    public void put(int n, Z z) {
        this.re[n - this.bx] = z.re;
        this.im[n - this.bx] = z.im;
    }

    public void put0(int n, Z z) {
        this.re[n] = z.re;
        this.im[n] = z.im;
    }
}

