/*
 * Decompiled with CFR 0.152.
 */
package Jampack;

import Jampack.JampackException;
import Jampack.Zmat;
import Jampack.Zutmat;

public class Zchol {
    public int n;
    public Zutmat R;

    public Zchol(Zmat zmat) throws JampackException {
        int n;
        zmat.getProperties();
        if (zmat.nr != zmat.nc) {
            throw new JampackException("Matrix not square.");
        }
        this.n = zmat.nr;
        this.R = new Zutmat(zmat);
        int n2 = 0;
        while (n2 < this.n) {
            if (this.R.im[n2][n2] != 0.0) {
                throw new JampackException("Matrix not Hermitian");
            }
            n = 0;
            while (n < n2) {
                if (this.R.re[n2][n] != this.R.re[n][n2] || this.R.im[n2][n] != -this.R.im[n][n2]) {
                    throw new JampackException("Matrix not Hermitian");
                }
                this.R.im[n2][n] = 0.0;
                this.R.re[n2][n] = 0.0;
                ++n;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.n) {
            if (this.R.re[n3][n3] <= 0.0) {
                throw new JampackException("Nonpositive diagonal entry during reduction.");
            }
            this.R.re[n3][n3] = Math.sqrt(this.R.re[n3][n3]);
            double d = 1.0 / this.R.re[n3][n3];
            n = n3 + 1;
            while (n < this.n) {
                this.R.re[n3][n] = d * this.R.re[n3][n];
                this.R.im[n3][n] = d * this.R.im[n3][n];
                ++n;
            }
            n2 = n3 + 1;
            while (n2 < this.n) {
                n = n2;
                while (n < this.n) {
                    this.R.re[n2][n] = this.R.re[n2][n] - this.R.re[n3][n2] * this.R.re[n3][n] - this.R.im[n3][n2] * this.R.im[n3][n];
                    this.R.im[n2][n] = this.R.im[n2][n] - this.R.re[n3][n2] * this.R.im[n3][n] + this.R.im[n3][n2] * this.R.re[n3][n];
                    ++n;
                }
                this.R.im[n2][n2] = 0.0;
                ++n2;
            }
            ++n3;
        }
    }
}

