/*
 * Decompiled with CFR 0.152.
 */
package Jampack;

import Jampack.JampackException;

public class Z {
    public static final Z ONE = new Z(1.0, 0.0);
    public static final Z ZERO = new Z(0.0, 0.0);
    public static final Z I = new Z(0.0, 1.0);
    public double re;
    public double im;

    public Z() {
        this.re = 0.0;
        this.im = 0.0;
    }

    public Z(double d, double d2) {
        this.re = d;
        this.im = d2;
    }

    public Z(double d) {
        this.re = d;
        this.im = 0.0;
    }

    public Z(Z z) {
        this.re = z.re;
        this.im = z.im;
    }

    public boolean IsEqual(Z z, Z z2) {
        return z.re == z2.re && z.im == z2.im;
    }

    public Z Eq(Z z) {
        this.re = z.re;
        this.im = z.im;
        return this;
    }

    public Z Eq(double d, double d2) {
        this.re = d;
        this.im = d2;
        return this;
    }

    public Z Exch(Z z) {
        double d = this.re;
        this.re = z.re;
        z.re = d;
        d = this.im;
        this.im = z.im;
        z.im = d;
        return this;
    }

    public static double abs1(Z z) {
        return Math.abs(z.re) + Math.abs(z.im);
    }

    public static double abs(Z z) {
        double d;
        double d2 = Math.abs(z.re);
        if (d2 + (d = Math.abs(z.im)) == 0.0) {
            return 0.0;
        }
        if (d2 >= d) {
            double d3 = d / d2;
            return d2 * Math.sqrt(1.0 + d3 * d3);
        }
        double d4 = d2 / d;
        return d * Math.sqrt(1.0 + d4 * d4);
    }

    public Z Conj(Z z) {
        this.re = z.re;
        this.im = -z.im;
        return this;
    }

    public Z Minus(Z z) {
        this.re = -z.re;
        this.im = -z.im;
        return this;
    }

    public Z Plus(Z z, Z z2) {
        this.re = z.re + z2.re;
        this.im = z.im + z2.im;
        return this;
    }

    public Z Minus(Z z, Z z2) {
        this.re = z.re - z2.re;
        this.im = z.im - z2.im;
        return this;
    }

    public Z Times(Z z, Z z2) {
        double d = z.re * z2.re - z.im * z2.im;
        this.im = z.im * z2.re + z.re * z2.im;
        this.re = d;
        return this;
    }

    public Z Times(double d, Z z) {
        this.re = d * z.re;
        this.im = d * z.im;
        return this;
    }

    public Z Div(Z z, Z z2) throws JampackException {
        double d = Z.abs(z2);
        if (d == 0.0) {
            throw new JampackException("Divide by zero.");
        }
        d = 1.0 / d;
        double d2 = z2.re * d;
        double d3 = -z2.im * d;
        double d4 = (z.re * d2 - z.im * d3) * d;
        this.im = (z.im * d2 + z.re * d3) * d;
        this.re = d4;
        return this;
    }

    public Z Div(Z z, double d) throws JampackException {
        if (d == 0.0) {
            throw new JampackException("Divide by zero.");
        }
        this.re = z.re / d;
        this.im = z.im / d;
        return this;
    }

    public Z Sqrt(Z z) {
        double d;
        double d2;
        double d3 = Z.abs(z);
        if (Math.abs(z.re) <= Math.abs(z.im)) {
            d2 = Math.sqrt(0.5 * (d3 + z.re));
            d = Math.sqrt(0.5 * (d3 - z.re));
        } else if (z.re > 0.0) {
            d2 = d3 + z.re;
            d = Math.abs(z.im) * Math.sqrt(0.5 / d2);
            d2 = Math.sqrt(0.5 * d2);
        } else {
            d = d3 - z.re;
            d2 = Math.abs(z.im) * Math.sqrt(0.5 / d);
            d = Math.sqrt(0.5 * d);
        }
        if (z.im < 0.0) {
            d = -d;
        }
        this.re = d2;
        this.im = d;
        return this;
    }
}

